﻿Imports System.Globalization

Public Class frmFM302_Control
    '2012-09-03 Just
    'Private Sub cmbReference_Leave()
    'Added a check if any mode is selected. If no probe is connected during start, there is no selected mode 
    'and so trying to access the mode would crash the application.

    Private WithEvents FM302 As New FM302
    Private WithEvents TimerComPorts As New System.Windows.Forms.Timer()
    Private tempLogFileName As String = System.IO.Path.GetTempFileName()
    Private LogContinuous As Boolean = False
    Private LogDivider As Integer

    Private Sub frmFM302_Control_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        'clear temporary logging file if form is closed
        FM302.Disconnect()
        System.IO.File.Delete(tempLogFileName)
    End Sub

    Private Sub frmFM302_Control_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        'insert version into application title
        Me.Text = Me.Text & " " & My.Application.Info.Version.ToString
        'insert version into status line
        tsslVersion.Text = My.Application.Info.Version.ToString

        'init combo box with available serial ports
        For Each PortName As String In My.Computer.Ports.SerialPortNames
            cmbPort.Items.Add(PortName)
        Next
        'set last element as selected as it's probabbly the virtual port of the device
        If cmbPort.Items.Count > 0 Then
            cmbPort.SelectedIndex = cmbPort.Items.Count - 1
        End If
        'set second element as selcted to use as default: ";" as value separator and "," as decimal separator 
        cmbSeparator.SelectedIndex = 1

        'set first element (x1) as default for y-axis scale of display
        cmbOsziY.SelectedIndex = 0
        'set display of limits in graph depending on global setting
        OsziChart.Series("UpperLimit").Enabled = My.Settings.limitShowInGraphDefault
        OsziChart.Series("LowerLimit").Enabled = My.Settings.limitShowInGraphDefault


        TimerComPorts.Interval = 1000
        TimerComPorts.Start()
    End Sub

#Region "Event Handler for FM302 events"

    Private Sub FM302_NewAbsMax(ByVal sender As Object, ByVal e As System.EventArgs) Handles FM302.NewAbsMax
        lblRefMinMaxCaption.Text = "|m|"
        lblRefMinMaxValue.Text = FM302.AbsMax.Value & " " & FM302.AbsMax.Unit
    End Sub

    Private Sub FM302_NewCoupling(ByVal sender As Object, ByVal e As System.EventArgs) Handles FM302.NewCoupling
        Dim index As Integer
        Select Case FM302.Coupling
            Case FM302_Control.FM302.CouplingState.CouplingDC
                index = cmbCoupling.FindString("DC")
            Case FM302_Control.FM302.CouplingState.CouplingAC
                index = cmbCoupling.FindString("AC")
        End Select
        cmbCoupling.SelectedIndex = index
    End Sub

    Private Sub FM302_NewFilter(ByVal sender As Object, ByVal e As System.EventArgs) Handles FM302.NewFilter
        cmbFilter.Text = FM302.Filter.ToString
    End Sub

    Private Sub FM302_NewGain(ByVal sender As Object, ByVal e As System.EventArgs) Handles FM302.NewGain
        Dim index As Integer
        Select Case FM302.Gain
            Case FM302_Control.FM302.GainState.GainX1
                index = cmbGain.FindString("x1")
            Case FM302_Control.FM302.GainState.GainX10
                index = cmbGain.FindString("x10")
            Case FM302_Control.FM302.GainState.GainX100
                index = cmbGain.FindString("x100")
        End Select
        cmbGain.SelectedIndex = index
    End Sub

    Private Sub FM302_NewKeyLock(ByVal sender As Object, ByVal e As System.EventArgs) Handles FM302.NewKeyLock
        Select Case FM302.KeyLock
            Case FM302_Control.FM302.KeyState.KeyboardLocked
                chkKeyboard.Checked = False
            Case FM302_Control.FM302.KeyState.KeyboardUnlocked
                chkKeyboard.Checked = True
        End Select
    End Sub

    Private Sub FM302_NewMaximum(ByVal sender As Object, ByVal e As System.EventArgs) Handles FM302.NewMaximum
        lblRefMinMaxCaption.Text = "max"
        lblRefMinMaxValue.Text = FM302.Maximum.Value & " " & FM302.Maximum.Unit
    End Sub

    Private Sub FM302_NewMeasuredValue(ByVal sender As Object, ByVal e As System.EventArgs) Handles FM302.NewMeasuredValue
        Dim valueToCheck As Double
        Dim upperLimit, lowerLimit, limitBuffer As Double

        '####################
        'write value to display
        lblDisplay.Text = FM302.MeasuredValue.Value & " " & FM302.MeasuredValue.Unit

        '####################
        'display N(orth) / S(outh) if mode is absolute
        If FM302.Mode = FM302_Control.FM302.ModeState.Absolute Then
            If FM302.MeasuredValue.Value >= 0 Then
                lblRefMinMaxValue.Text = "S"
            Else
                lblRefMinMaxValue.Text = "N"
            End If
        End If

        '####################
        'write value to oszi display
        Try
            If OsziChart.Series("OsziSeries").Points.Count > 100 Then
                OsziChart.Series("OsziSeries").Points.RemoveAt(0)
            End If
            'OsziChart.Series("OsziSeries").Points.AddY(Val(FM302.MeasuredValue.Value))
            OsziChart.Series("OsziSeries").Points.AddY(Val(FM302.MeasuredValue.Value))
        Catch ex As Exception
        End Try

        '####################
        'write value to log if logging is active
        If LogContinuous Then
            LogDivider -= 1
            pgbLoging.PerformStep()
            If LogDivider = 0 Then
                WriteLineToLog()
                LogDivider = nudLogDivider.Value
                pgbLoging.Value = 0
            End If
        End If

        '####################
        'check value to limits
        valueToCheck = Val(FM302.MeasuredValue.Value)
        upperLimit = Val(txtUpperLimit.Text)
        lowerLimit = Val(txtLowerLimit.Text)


        'Compare only if upper limit is greater than lower limit. Otherwise compare is useless.
        If upperLimit >= lowerLimit Then
            'check if ignorance of polarity is activated
            If chkIgnorePolarity.Checked Then
                'use absolute value of measured value for comparison
                valueToCheck = Math.Abs(valueToCheck)
                'invert limits if they are more in the negative range
                If Math.Abs(upperLimit) < Math.Abs(lowerLimit) Then
                    limitBuffer = -upperLimit
                    upperLimit = -lowerLimit
                    lowerLimit = limitBuffer
                End If
            End If

            'check if over lower limit
            If valueToCheck >= lowerLimit Then
                'if over lower limit, check if under upper limit
                If valueToCheck <= upperLimit Then
                    'value is over lower limit and under upper limit => value ok
                    lblLimitHigher.BackColor = My.Settings.limitHighColorInactive
                    lblLimitOK.BackColor = My.Settings.limitOkColorActive
                    lblLimitLower.BackColor = My.Settings.limitLowColorInactive
                Else
                    'value is over lower limit but also over upper limit => value to high
                    lblLimitHigher.BackColor = My.Settings.limitHighColorActive
                    lblLimitOK.BackColor = My.Settings.limitOKColorInactive
                    lblLimitLower.BackColor = My.Settings.limitLowColorInactive
                End If
            Else
                'value is under lower limit => value to low
                lblLimitHigher.BackColor = My.Settings.limitHighColorInactive
                lblLimitOK.BackColor = My.Settings.limitOKColorInactive
                lblLimitLower.BackColor = My.Settings.limitLowColorActive
            End If
        Else
            'deactivate all signaling while limits are invalid
            lblLimitHigher.BackColor = My.Settings.limitHighColorInactive
            lblLimitOK.BackColor = My.Settings.limitOKColorInactive
            lblLimitLower.BackColor = My.Settings.limitLowColorInactive
        End If
    End Sub

    Private Sub FM302_NewMinimum(ByVal sender As Object, ByVal e As System.EventArgs) Handles FM302.NewMinimum
        lblRefMinMaxCaption.Text = "min"
        lblRefMinMaxValue.Text = FM302.Minimum.Value & " " & FM302.Minimum.Unit
    End Sub

    Private Sub FM302_NewMode(ByVal sender As Object, ByVal e As System.EventArgs) Handles FM302.NewMode
        Try
            cmbMode.SelectedIndex = cmbMode.FindString(FM302.Modes.Item(FM302.Mode))
        Catch
        End Try

        Select Case FM302.Mode
            Case FM302_Control.FM302.ModeState.Absolute
                lblRefMinMaxCaption.Text = String.Empty
                lblRefMinMaxValue.Text = String.Empty
            Case FM302_Control.FM302.ModeState.Relative
                lblRefMinMaxCaption.Text = "ref"
                lblRefMinMaxValue.Text = FM302.Reference.Value & " " & FM302.Reference.Unit
            Case FM302_Control.FM302.ModeState.Maximum
                lblRefMinMaxCaption.Text = "max"
                lblRefMinMaxValue.Text = FM302.Maximum.Value & " " & FM302.Maximum.Unit
            Case FM302_Control.FM302.ModeState.Minimum
                lblRefMinMaxCaption.Text = "min"
                lblRefMinMaxValue.Text = FM302.Minimum.Value & " " & FM302.Minimum.Unit
            Case FM302_Control.FM302.ModeState.AbsMax
                lblRefMinMaxCaption.Text = "|m|"
                lblRefMinMaxValue.Text = FM302.AbsMax.Value & " " & FM302.AbsMax.Unit
        End Select

        SetOsziScaleY()
    End Sub

    Private Sub FM302_NewModes(sender As Object, e As System.EventArgs) Handles FM302.NewModes
        cmbMode.Items.Clear()
        For Each kvp As KeyValuePair(Of FM302.ModeState, String) In FM302.Modes
            cmbMode.Items.Add(kvp)
        Next kvp
        cmbMode.DisplayMember = "Value"
        cmbMode.ValueMember = "Key"

        Try
            cmbMode.SelectedIndex = cmbMode.FindString(FM302.Modes.Item(FM302.Mode))
        Catch
        End Try
    End Sub

    Private Sub FM302_NewNoProbe(ByVal sender As Object, ByVal e As System.EventArgs) Handles FM302.NewNoProbe
        lblDisplay.Text = "no probe"
        lblRefMinMaxCaption.Text = String.Empty
        lblRefMinMaxValue.Text = String.Empty
        lblRangeValue.Text = String.Empty
    End Sub

    Private Sub FM302_NewOverload(ByVal sender As Object, ByVal e As System.EventArgs) Handles FM302.NewOverload
        Dim dataPoint As New System.Windows.Forms.DataVisualization.Charting.DataPoint

        lblDisplay.Text = "overload"

        dataPoint.IsEmpty = True
        If OsziChart.Series("OsziSeries").Points.Count > 100 Then
            OsziChart.Series("OsziSeries").Points.RemoveAt(0)
        End If
        'OsziChart.Series("OsziSeries").Points.AddY(Val(FM302.MeasuredValue.Value))
        OsziChart.Series("OsziSeries").Points.Add(dataPoint)

        If LogContinuous And chkLogOverload.Checked Then
            WriteLineToLog()
        End If
    End Sub

    Private Sub FM302_NewRange(ByVal sender As Object, ByVal e As System.EventArgs) Handles FM302.NewRange
        lblRangeValue.Text = FM302.Range.Value & " " & FM302.Range.Unit

        OsziChart.Series("OsziSeries").Points.Clear()
        SetOsziScaleY()
    End Sub

    Private Sub FM302_NewReference(ByVal sender As Object, ByVal e As System.EventArgs) Handles FM302.NewReference
        lblRefMinMaxCaption.Text = "ref"
        lblRefMinMaxValue.Text = FM302.Reference.Value & " " & FM302.Reference.Unit
        cmbReference.Text = FM302.Reference.Value

        SetOsziScaleY()
    End Sub

    Private Sub FM302_NewSerial(ByVal sender As Object, ByVal e As System.EventArgs) Handles FM302.NewSerial
        lblSerial.Text = "serial number: " & FM302.Serial
    End Sub

    Private Sub FM302_NewSound(ByVal sender As Object, ByVal e As System.EventArgs) Handles FM302.NewSound
        Select Case FM302.Sound
            Case FM302_Control.FM302.SoundState.SoundOn
                chkSound.Checked = True
            Case FM302_Control.FM302.SoundState.SoundOff
                chkSound.Checked = False
        End Select
    End Sub

    Private Sub FM302_NewTime(ByVal sender As Object, ByVal e As System.EventArgs) Handles FM302.NewTime
        Dim timePerDiv As Integer

        timePerDiv = FM302.Time / 100

        cmbTime.Text = FM302.Time.ToString
        lblTimeDiv.Text = timePerDiv.ToString & "s per div"
        OsziChart.Series("OsziSeries").Points.Clear()

        SetLogIntervalLabel()
    End Sub

    Private Sub FM302_NewUnit(ByVal sender As Object, ByVal e As System.EventArgs) Handles FM302.NewUnit
        Try
            cmbUnit.SelectedIndex = cmbUnit.FindString(FM302.Units.Item(FM302.Unit))
        Catch
        End Try
    End Sub

    Private Sub FM302_NewUnits(sender As Object, e As System.EventArgs) Handles FM302.NewUnits
        cmbUnit.Items.Clear()
        For Each kvp As KeyValuePair(Of FM302.UnitState, String) In FM302.Units
            cmbUnit.Items.Add(kvp)
        Next kvp
        cmbUnit.DisplayMember = "Value"
        cmbUnit.ValueMember = "Key"

        Try
            cmbUnit.SelectedIndex = cmbUnit.FindString(FM302.Units.Item(FM302.Unit))
        Catch
        End Try
    End Sub

    Private Sub FM302_NewVersion(ByVal sender As Object, ByVal e As System.EventArgs) Handles FM302.NewVersion
        lblVersion.Text = "firmware version: " & FM302.Version
    End Sub

    Private Sub FM302_NewZero(ByVal sender As Object, ByVal e As System.EventArgs) Handles FM302.NewZero
        cmbZero.Text = FM302.Zero.ToString
        cmbZero.Enabled = True
        lblZeroSetting.Visible = False
    End Sub

    Private Sub FM302_ZeroOutOfRange(ByVal sender As Object, ByVal e As System.EventArgs) Handles FM302.ZeroOutOfRange
        MsgBox("Offset is out of range for zero compensation.", vbInformation + vbOKOnly, "offset out of range")
    End Sub

#End Region

    Private Sub btnConnect_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnConnect.Click
        If Not FM302.IsConnected Then
            ConnectFM302()
        Else
            DisconnectFM302()
            StopContinuousLogging()
        End If
    End Sub

    Private Sub btnClearLog_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnClearLog.Click
        If MsgBox("Do you really want to clear the logged data?", vbYesNo + vbQuestion, "clear data?") = vbYes Then
            txtLog.Text = String.Empty
            Try
                System.IO.File.Delete(tempLogFileName)
            Catch ex As Exception
            End Try
        End If
    End Sub

    Private Sub btnDefault_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDefault.Click
        If MsgBox("Do you really want to restore the factory default settings of the FM302?", vbQuestion + vbYesNo, "restore defaults") = vbYes Then
            FM302.RestoreDefault()
        End If
    End Sub

    Private Sub btnLogSingle_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnLogSingle.Click
        WriteLineToLog()
    End Sub

    Private Sub btnLogStart_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnLogStart.Click
        StartContinuousLogging()
    End Sub

    Private Sub btnLogStop_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnLogStop.Click
        StopContinuousLogging()
    End Sub

    Private Sub btnSaveImage_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSaveImage.Click
        Dim tempFileNameJPG As String = System.IO.Path.GetTempFileName()
        Dim tempFileNamePNG As String = System.IO.Path.GetTempFileName()
        Dim tempFileNameBMP As String = System.IO.Path.GetTempFileName()
        Dim tempFileNameTIF As String = System.IO.Path.GetTempFileName()
        Dim tempFileNameGIF As String = System.IO.Path.GetTempFileName()
        Dim tempFileNameEMF As String = System.IO.Path.GetTempFileName()

        'save image to temp file to keep state of moment of butten press
        OsziChart.SaveImage(tempFileNameJPG, DataVisualization.Charting.ChartImageFormat.Jpeg)
        OsziChart.SaveImage(tempFileNamePNG, DataVisualization.Charting.ChartImageFormat.Png)
        OsziChart.SaveImage(tempFileNameBMP, DataVisualization.Charting.ChartImageFormat.Bmp)
        OsziChart.SaveImage(tempFileNameTIF, DataVisualization.Charting.ChartImageFormat.Tiff)
        OsziChart.SaveImage(tempFileNameGIF, DataVisualization.Charting.ChartImageFormat.Gif)
        OsziChart.SaveImage(tempFileNameEMF, DataVisualization.Charting.ChartImageFormat.Emf)

        sfdImage.Filter = "JPEG Image (*.jpeg)|*.jpeg|PNG Image (*.png)|*.png|BMP Image (*.bmp)|*.bmp|TIFF Image (*.tiff)|*.tiff|GIF Image (*.gif)|*.gif|EMF Image (*.emf)|*.emf|all files (*.*)|*.*"
        sfdImage.DefaultExt = "jpeg"
        sfdImage.FileName = "image " & DateAndTime.Now.ToString("yyyy-MM-dd HH-mm-ss")
        If sfdImage.ShowDialog() = Windows.Forms.DialogResult.OK Then
            Try
                'depending on the choosen file type, copy corresponding temp file to choosen file name
                Select Case sfdImage.FileName.Substring(sfdImage.FileName.LastIndexOf("."))
                    Case ".jpg", ".jpeg"
                        System.IO.File.Copy(tempFileNameJPG, sfdImage.FileName, True)
                    Case ".png"
                        System.IO.File.Copy(tempFileNamePNG, sfdImage.FileName, True)
                    Case ".bmp"
                        System.IO.File.Copy(tempFileNameBMP, sfdImage.FileName, True)
                    Case ".tif", ".tiff"
                        System.IO.File.Copy(tempFileNameTIF, sfdImage.FileName, True)
                    Case ".gif"
                        System.IO.File.Copy(tempFileNameGIF, sfdImage.FileName, True)
                    Case ".emf"
                        System.IO.File.Copy(tempFileNameEMF, sfdImage.FileName, True)
                    Case Else
                        Select Case sfdImage.FilterIndex
                            Case 1
                                System.IO.File.Copy(tempFileNameJPG, sfdImage.FileName & ".jpeg", True)
                            Case 2
                                System.IO.File.Copy(tempFileNamePNG, sfdImage.FileName & ".png", True)
                            Case 3
                                System.IO.File.Copy(tempFileNameBMP, sfdImage.FileName & ".bmp", True)
                            Case 4
                                System.IO.File.Copy(tempFileNameTIF, sfdImage.FileName & ".tiff", True)
                            Case 5
                                System.IO.File.Copy(tempFileNameGIF, sfdImage.FileName & ".gif", True)
                            Case 6
                                System.IO.File.Copy(tempFileNameEMF, sfdImage.FileName & ".emf", True)
                            Case Else
                                System.IO.File.Copy(tempFileNameJPG, sfdImage.FileName & ".jpeg", True)
                        End Select

                End Select
            Catch ex As Exception
                MsgBox("error while saving file", MsgBoxStyle.OkOnly + MsgBoxStyle.Critical)
            End Try
        End If
        'delete temp files
        Try
            System.IO.File.Delete(tempFileNameJPG)
            System.IO.File.Delete(tempFileNamePNG)
            System.IO.File.Delete(tempFileNameBMP)
            System.IO.File.Delete(tempFileNameTIF)
            System.IO.File.Delete(tempFileNameGIF)
            System.IO.File.Delete(tempFileNameEMF)
        Catch ex As Exception
        End Try
    End Sub

    Private Sub btnSaveLog_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnSaveLog.Click
        If LogContinuous Then
            If MsgBox("This will stop the currently running logging." & vbNewLine & vbNewLine & "Do you want to continue?", vbYesNo + vbQuestion, "abort logging?") = vbNo Then
                Exit Sub
            Else
                StopContinuousLogging()
            End If
        End If
        sfdLog.FileName = "logfile " & DateAndTime.Now.ToString("yyyy-MM-dd HH-mm-ss") & ".log"
        If sfdLog.ShowDialog() = Windows.Forms.DialogResult.OK Then
            Try
                System.IO.File.Copy(tempLogFileName, sfdLog.FileName, True)
            Catch ex As Exception
                MsgBox("error while saving file", MsgBoxStyle.OkOnly + MsgBoxStyle.Critical)
            End Try
        End If
    End Sub

    Private Sub chkKeyboard_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkKeyboard.CheckedChanged
        Dim keylock As FM302.KeyState
        Select Case chkKeyboard.Checked
            Case True
                keylock = FM302_Control.FM302.KeyState.KeyboardUnlocked
            Case False
                keylock = FM302_Control.FM302.KeyState.KeyboardLocked
        End Select
        'update keylock only if keylock has changed
        If FM302.KeyLock <> keylock Then
            FM302.KeyLock = keylock
        End If
    End Sub

    Private Sub chkSound_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkSound.CheckedChanged
        Dim sound As FM302.SoundState
        Select Case chkSound.Checked
            Case True
                sound = FM302_Control.FM302.SoundState.SoundOn
            Case False
                sound = FM302_Control.FM302.SoundState.SoundOff
        End Select
        'update sound only if sound has been changed
        If FM302.Sound <> sound Then
            FM302.Sound = sound
        End If
    End Sub

    Private Sub cmbCoupling_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmbCoupling.SelectedIndexChanged
        Dim coupling As FM302.CouplingState
        Select Case cmbCoupling.SelectedItem.ToString
            Case "DC"
                coupling = FM302_Control.FM302.CouplingState.CouplingDC
            Case "AC"
                coupling = FM302_Control.FM302.CouplingState.CouplingAC
        End Select
        'only update coupling, if coupling has changed
        If FM302.Coupling <> coupling Then
            FM302.Coupling = coupling
        End If
    End Sub

    Private Sub cmbGain_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmbGain.SelectedIndexChanged
        Dim gain As FM302.GainState
        Select Case cmbGain.SelectedItem.ToString
            Case "x1"
                gain = FM302_Control.FM302.GainState.GainX1
            Case "x10"
                gain = FM302_Control.FM302.GainState.GainX10
            Case "x100"
                gain = FM302_Control.FM302.GainState.GainX100
        End Select
        'only update gain if gain has changed
        If FM302.Gain <> gain Then
            FM302.Gain = gain
        End If
    End Sub

    Private Sub cmbUnit_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmbUnit.SelectedIndexChanged
        Dim unit As FM302.UnitState

        unit = CType(cmbUnit.SelectedItem, KeyValuePair(Of FM302.UnitState, String)).Key

        'update unit only if unit has changed
        If FM302.Unit <> unit Then
            FM302.Unit = unit
        End If
    End Sub

    Private Sub cmbMode_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmbMode.SelectedIndexChanged
        Dim mode As FM302.ModeState

        mode = CType(cmbMode.SelectedItem, KeyValuePair(Of FM302.ModeState, String)).Key

        'update mode only if mode has changed
        If FM302.Mode <> mode Then
            FM302.Mode = mode
            lblRefMinMaxCaption.Text = String.Empty
            lblRefMinMaxValue.Text = String.Empty
        End If
    End Sub

    Private Sub cmbTime_Leave(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmbTime.Leave
        Dim TimeCandidate As Integer = Val(cmbTime.Text)

        lblTimeInvalid.Visible = False

        If (TimeCandidate Mod 100 <> 0) Or (TimeCandidate < 100) Or (TimeCandidate > 25500) Then
            'if value is invalid, restore current value
            cmbTime.Text = FM302.Time.ToString
        Else
            'only update time if time has changed
            If FM302.Time <> Val(cmbTime.Text) Then
                FM302.Time = Val(cmbTime.Text)
            End If
        End If
    End Sub

    Private Sub cmbTime_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmbTime.SelectedIndexChanged
        'only update time if time has changed
        If FM302.Time <> Val(cmbTime.SelectedItem.ToString) Then
            FM302.Time = Val(cmbTime.SelectedItem.ToString)
        End If
    End Sub

    Private Sub cmbTime_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmbTime.TextChanged
        Dim TimeCandidate As Integer = Val(cmbTime.Text)

        'check if time is divideable by 100 and within the range of 100 to 25500
        If (TimeCandidate Mod 100 <> 0) Or (TimeCandidate < 100) Or (TimeCandidate > 25500) Then
            lblTimeInvalid.Visible = True
        Else
            lblTimeInvalid.Visible = False
        End If
    End Sub

    Private Sub cmbFilter_Leave(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmbFilter.Leave
        Dim FilterCandidate As Integer = Val(cmbFilter.Text)

        lblFilterInvalid.Visible = False

        If (FilterCandidate < 1) Or (FilterCandidate > 64) Then
            'if value is invalid, restore current value
            cmbFilter.Text = FM302.Filter.ToString
        Else
            'only update filter if filter has changed
            If FM302.Filter <> Val(cmbFilter.Text) Then
                FM302.Filter = Val(cmbFilter.Text)
            End If
        End If
    End Sub

    Private Sub cmbFilter_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmbFilter.SelectedIndexChanged
        'only update filter if filter has changed
        If FM302.Filter <> Val(cmbFilter.SelectedItem.ToString) Then
            FM302.Filter = Val(cmbFilter.SelectedItem.ToString)
        End If
    End Sub

    Private Sub cmbFilter_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmbFilter.TextChanged
        Dim FilterCandidate As Integer = Val(cmbFilter.Text)

        'check if time is divideable by 100 and within the range of 100 to 25500
        If (FilterCandidate < 1) Or (FilterCandidate > 64) Then
            lblFilterInvalid.Visible = True
        Else
            lblFilterInvalid.Visible = False
        End If
    End Sub

    Private Sub cmbReference_Leave(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmbReference.Leave
        '2012-09-03 Just
        'Added a check if any mode is selected. If no probe is connected during start, there is no selected mode 
        'and so trying to access the mode would crash the application.

        'exit sub if no mode is selected
        'If cmbMode.SelectedItem = Nothing Then
        If CType(cmbMode.SelectedItem, KeyValuePair(Of FM302.ModeState, String)).Key = FM302_Control.FM302.ModeState.NotSet Then
            Exit Sub
        End If

        'set relative value if mode is relative
        If CType(cmbMode.SelectedItem, KeyValuePair(Of FM302.ModeState, String)).Key = FM302_Control.FM302.ModeState.Relative Then
            FM302.RelativeSet(Val(cmbReference.Text))
        End If
    End Sub

    Private Sub cmbReference_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmbReference.SelectedIndexChanged
        FM302.RelativeSet(Val(cmbReference.Text))
    End Sub

    Private Sub cmbZero_Leave(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmbZero.Leave
        Dim ZeroCandidate As Integer = Val(cmbZero.Text)

        lblZeroInvalid.Visible = False

        'call auto is choosen, the setting has already been started
        If cmbZero.Text = "auto" Then
            Exit Sub
        End If

        If (ZeroCandidate < -39320) Or (ZeroCandidate > 26213) Then
            'value is invalid, restore current value
            cmbZero.Text = FM302.Zero.ToString
        Else
            'only update zero if zero has changed
            If FM302.Zero <> ZeroCandidate Then
                FM302.Zero = ZeroCandidate
                cmbZero.Enabled = False
                lblZeroSetting.Visible = True
            End If
        End If

    End Sub

    Private Sub cmbZero_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmbZero.SelectedIndexChanged
        Dim ZeroCandidate As Integer = Val(cmbZero.Text)

        'call auto zero setting if auto was selected
        If cmbZero.SelectedItem.ToString = "auto" Then
            FM302.ZeroSet()
            cmbZero.Enabled = False
            lblZeroSetting.Visible = True
            Exit Sub
        End If

        'only update zero if zero has changed
        If FM302.Zero <> ZeroCandidate Then
            FM302.Zero = ZeroCandidate
            cmbZero.Enabled = False
            lblZeroSetting.Visible = True
        End If
    End Sub

    Private Sub cmbZero_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmbZero.TextChanged
        Dim ZeroCandidate As Integer = Val(cmbZero.Text)

        'check if zero is within the allowed range
        If (ZeroCandidate < -39320) Or (ZeroCandidate > 26213) Then
            lblZeroInvalid.Visible = True
        Else
            lblZeroInvalid.Visible = False
        End If
    End Sub

    Private Sub nudLogDivider_ValueChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles nudLogDivider.ValueChanged
        If nudLogDivider.Value > nudLogDivider.Maximum Then
            nudLogDivider.Value = nudLogDivider.Maximum
        ElseIf nudLogDivider.Value < nudLogDivider.Minimum Then
            nudLogDivider.Value = nudLogDivider.Minimum
        End If
        nudLogDivider.Value = Decimal.Round(nudLogDivider.Value)

        SetLogIntervalLabel()
    End Sub

    Private Sub rbLog_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles rbLogContinuous.CheckedChanged, rbLogSingle.CheckedChanged
        EnableLoggingGroupBox(True)
        StopContinuousLogging()
    End Sub

    Private Sub TimerComPorts_Tick(ByVal sender As Object, ByVal e As System.EventArgs) Handles TimerComPorts.Tick
        Dim index As Integer

        'test if there are new ports available and add them to combo box
        For Each PortName As String In My.Computer.Ports.SerialPortNames
            index = cmbPort.FindString(PortName)
            If index = -1 Then
                cmbPort.Items.Add(PortName)
            End If
        Next

        'test if there are ports in the combo box that are no longer available
        For Each PortName As String In cmbPort.Items
            If Not My.Computer.Ports.SerialPortNames.Contains(PortName) Then
                If FM302.PortName = PortName Then
                    DisconnectFM302()
                End If
                cmbPort.Items.Remove(PortName)
                Exit For
            End If
        Next

        If Not FM302.IsConnected Then
            'SetControlsDisconnected()
        End If
    End Sub

    Private Sub txtUpperLimit_TextChanged(sender As System.Object, e As System.EventArgs) Handles txtUpperLimit.TextChanged
        Dim dataPoint As System.Windows.Forms.DataVisualization.Charting.DataPoint
        Dim limit As Double


        If Val(txtUpperLimit.Text) < Val(txtLowerLimit.Text) Then
            'display error message
            lblLimitInvalid.Visible = True
            'hide limits in graph
            OsziChart.Series("UpperLimit").Enabled = False
            OsziChart.Series("LowerLimit").Enabled = False
        Else
            'hide error message
            lblLimitInvalid.Visible = False


            limit = Val(txtUpperLimit.Text)
            'write limit to oszi display
            Try
                OsziChart.Series("UpperLimit").Points.Clear()
                For x = 0 To 100
                    If x Mod 4 < 1 Then
                        dataPoint = New System.Windows.Forms.DataVisualization.Charting.DataPoint
                        dataPoint.IsEmpty = True
                        OsziChart.Series("UpperLimit").Points.Add(dataPoint)
                    Else
                        OsziChart.Series("UpperLimit").Points.AddY(limit)
                    End If
                Next
            Catch ex As Exception
            End Try

            'show limits if showing is activated
            OsziChart.Series("UpperLimit").Enabled = chkShowLimitInOszi.Checked
            OsziChart.Series("LowerLimit").Enabled = chkShowLimitInOszi.Checked
        End If
    End Sub

    Private Sub txtUpperLimit_Leave(sender As Object, e As System.EventArgs) Handles txtUpperLimit.Leave
        Dim limit As Double

        limit = Val(txtUpperLimit.Text)
        txtUpperLimit.Text = limit.ToString(CultureInfo.InvariantCulture)
    End Sub

    Private Sub txtLowerLimit_TextChanged(sender As Object, e As System.EventArgs) Handles txtLowerLimit.TextChanged
        Dim dataPoint As System.Windows.Forms.DataVisualization.Charting.DataPoint
        Dim limit As Double


        If Val(txtUpperLimit.Text) < Val(txtLowerLimit.Text) Then
            'display error message
            lblLimitInvalid.Visible = True
            'hide limits in graph
            OsziChart.Series("UpperLimit").Enabled = False
            OsziChart.Series("LowerLimit").Enabled = False
        Else
            'hide error message
            lblLimitInvalid.Visible = False


            limit = Val(txtLowerLimit.Text)
            'write limit to oszi display
            Try
                OsziChart.Series("LowerLimit").Points.Clear()
                For x = 0 To 100
                    If x Mod 4 < 1 Then
                        dataPoint = New System.Windows.Forms.DataVisualization.Charting.DataPoint
                        dataPoint.IsEmpty = True
                        OsziChart.Series("LowerLimit").Points.Add(dataPoint)
                    Else
                        OsziChart.Series("LowerLimit").Points.AddY(limit)
                    End If
                Next
            Catch ex As Exception
            End Try

            'show limits if showing is activated
            OsziChart.Series("UpperLimit").Enabled = chkShowLimitInOszi.Checked
            OsziChart.Series("LowerLimit").Enabled = chkShowLimitInOszi.Checked
        End If
    End Sub

    Private Sub txtLowerLimit_Leave(sender As Object, e As System.EventArgs) Handles txtLowerLimit.Leave
        Dim limit As Double

        limit = Val(txtLowerLimit.Text)
        txtLowerLimit.Text = limit.ToString(CultureInfo.InvariantCulture)
    End Sub

    Private Sub ConnectFM302()
        '2018-08-29 T. Just
        'catch error if no entry is selected
        'this can happen if there are no COM ports available and so the list is empty
        Try
            FM302.PortName = cmbPort.SelectedItem.ToString
        Catch
            Exit Sub
        End Try

        Try
            FM302.Connect()
        Catch ex As Exception
            MsgBox("Error while trying to connect.")
            Exit Sub
        End Try

        'we are successfully connected
        If FM302.IsConnected Then
            btnConnect.Text = "disconnect"
            EnableControls()
        End If
    End Sub

    Private Sub DisconnectFM302()
        SetControlsDisconnected()
        FM302.Disconnect()
    End Sub

    Private Sub EnableControls()
        EnableControls(True)
    End Sub

    Private Sub DisableControls()
        EnableControls(False)
    End Sub

    Private Sub EnableControls(ByVal enable As Boolean)
        chkKeyboard.Enabled = enable
        chkSound.Enabled = enable
        cmbCoupling.Enabled = enable
        cmbGain.Enabled = enable
        cmbUnit.Enabled = enable
        cmbMode.Enabled = enable
        cmbOsziY.Enabled = enable
        cmbTime.Enabled = enable
        cmbFilter.Enabled = enable
        cmbReference.Enabled = enable
        cmbZero.Enabled = enable
        btnDefault.Enabled = enable
        'btnSaveImage.Enabled = enable
        'btnSaveLog.Enabled = enable
        btnClearLog.Enabled = enable
        gpbLogging.Enabled = enable
        EnableLoggingGroupBox(enable)
        txtUpperLimit.Enabled = enable
        txtLowerLimit.Enabled = enable
        chkIgnorePolarity.Enabled = enable
        chkShowLimitInOszi.Enabled = enable
        lblLimitHigher.BackColor = My.Settings.limitHighColorInactive
        lblLimitOK.BackColor = My.Settings.limitOKColorInactive
        lblLimitLower.BackColor = My.Settings.limitLowColorInactive
    End Sub

    Private Sub EnableLoggingGroupBox(ByVal enable As Boolean)
        If enable Then
            If rbLogContinuous.Checked Then
                gpbSingleLog.Enabled = False
                gpbContinuousLog.Enabled = True
            ElseIf rbLogSingle.Checked Then
                gpbSingleLog.Enabled = True
                gpbContinuousLog.Enabled = False
            End If
        Else
            gpbSingleLog.Enabled = False
            gpbContinuousLog.Enabled = False
        End If
    End Sub

    Private Sub SetControlsDisconnected()
        btnConnect.Text = "connect"
        lblDisplay.Text = String.Empty
        lblRefMinMaxCaption.Text = String.Empty
        lblRefMinMaxValue.Text = String.Empty
        lblRangeValue.Text = String.Empty
        lblSerial.Text = "serial number:"
        lblVersion.Text = "firmware version:"
        DisableControls()
    End Sub

    Private Sub SetLogIntervalLabel()
        Dim logInterval_dbl As Double
        Dim logInterval_date As Date


        logInterval_dbl = FM302.Time / CDbl(1000)
        logInterval_dbl *= nudLogDivider.Value

        logInterval_date = logInterval_date.AddSeconds(logInterval_dbl)

        If logInterval_dbl < 60 Then
            lblLogInterval.Text = "log every " & logInterval_date.ToString("s.f") & " s"
        ElseIf logInterval_dbl < 3600 Then
            lblLogInterval.Text = "log every " & logInterval_date.ToString("m:ss.f") & " m"
        Else
            lblLogInterval.Text = "log every " & logInterval_date.ToString("H:mm:ss.f") & " h"
        End If
    End Sub

    Private Sub SetOsziScaleY()
        Dim range As Double
        Dim reference As Double = 0

        Try
            range = Val(FM302.Range.Value)
            'exit if range is not set
            If range = 0 Then
                Exit Sub
            End If

            If FM302.Mode = FM302_Control.FM302.ModeState.Relative Then
                reference = Val(FM302.Reference.Value)
            End If

            'use smaler range if set for oszi image and center zero line
            Select Case cmbOsziY.SelectedItem.ToString
                Case "x1"
                    range /= 1
                Case "x10"
                    range /= 10
                    reference = 0
                Case "x100"
                    range /= 100
                    reference = 0
                Case "x1000"
                    range /= 1000
                    reference = 0
            End Select


            OsziChart.ChartAreas("OsziChartArea").AxisY.Maximum = range / 2 * 2.51 - reference
            OsziChart.ChartAreas("OsziChartArea").AxisY.Minimum = -range / 2 * 2.51 - reference
            OsziChart.ChartAreas("OsziChartArea").AxisY.Interval = range / 4
            OsziChart.ChartAreas("OsziChartArea").AxisY.IntervalOffset = (range / 200 + reference) Mod (range / 4)
            If range > 10 Then
                OsziChart.ChartAreas("OsziChartArea").AxisY.LabelStyle.Format = "0 " & FM302.Range.Unit
            ElseIf range > 1 Then
                OsziChart.ChartAreas("OsziChartArea").AxisY.LabelStyle.Format = "0.0 " & FM302.Range.Unit
            ElseIf range > 0.1 Then
                OsziChart.ChartAreas("OsziChartArea").AxisY.LabelStyle.Format = "0.00 " & FM302.Range.Unit
            ElseIf range > 0.01 Then
                OsziChart.ChartAreas("OsziChartArea").AxisY.LabelStyle.Format = "0.000 " & FM302.Range.Unit
            Else
                OsziChart.ChartAreas("OsziChartArea").AxisY.LabelStyle.Format = "0.0000 " & FM302.Range.Unit
            End If
        Catch ex As Exception
        End Try
    End Sub

    Private Sub WriteLineToLog()
        Dim LogFile As System.IO.StreamWriter
        Dim LogLine As String

        'don't log if no probe is connected
        If FM302.NoProbe Then
            Exit Sub
        End If

        LogLine = DateAndTime.Now.ToString("yyyy-MM-dd HH:mm:ss.f", Nothing)
        If FM302.Overload Then
            LogLine &= ", overload"
        Else
            LogLine &= ", " & FM302.MeasuredValue.Value & ", " & FM302.MeasuredValue.Unit
            Select Case FM302.Mode
                Case FM302_Control.FM302.ModeState.Relative
                    LogLine &= ", ref, " & FM302.Reference.Value & ", " & FM302.Reference.Unit
                Case FM302_Control.FM302.ModeState.Maximum
                    LogLine &= ", max, " & FM302.Maximum.Value & ", " & FM302.Maximum.Unit
                Case FM302_Control.FM302.ModeState.Minimum
                    LogLine &= ", min, " & FM302.Minimum.Value & ", " & FM302.Minimum.Unit
            End Select
        End If

        'replace "," with ";" and "." with "," if the log format is set so
        If cmbSeparator.SelectedIndex = 1 Then
            LogLine = LogLine.Replace(",", ";")
            LogLine = LogLine.Replace(".", ",")
        End If

        Try
            LogFile = System.IO.File.AppendText(tempLogFileName)
            LogFile.WriteLine(LogLine)
            LogFile.Close()
        Catch ex As Exception
        End Try

        While txtLog.Lines.Count() > 19
            txtLog.Text = txtLog.Text.Substring(0, txtLog.Text.LastIndexOf(vbNewLine))
        End While
        txtLog.Text = LogLine & vbNewLine & txtLog.Text
    End Sub

    Private Sub StartContinuousLogging()
        LogContinuous = True
        btnLogStart.Enabled = False
        btnLogStop.Enabled = True
        nudLogDivider.Enabled = False
        chkLogOverload.Enabled = False
        gpbLogging.Enabled = False

        LogDivider = nudLogDivider.Value
        pgbLoging.Maximum = nudLogDivider.Value - 1
    End Sub

    Private Sub StopContinuousLogging()
        LogContinuous = False
        btnLogStart.Enabled = True
        btnLogStop.Enabled = False
        nudLogDivider.Enabled = True
        chkLogOverload.Enabled = True
        If FM302.IsConnected Then
            gpbLogging.Enabled = True
        End If

        pgbLoging.Value = 0
    End Sub

    Private Sub CheckBox1_CheckedChanged(sender As System.Object, e As System.EventArgs) Handles chkShowLimitInOszi.CheckedChanged
        Try
            OsziChart.Series("UpperLimit").Enabled = chkShowLimitInOszi.Checked
            OsziChart.Series("LowerLimit").Enabled = chkShowLimitInOszi.Checked
        Catch ex As Exception

        End Try
    End Sub

    Private Sub cmbOsziY_SelectedIndexChanged(sender As System.Object, e As System.EventArgs) Handles cmbOsziY.SelectedIndexChanged
        SetOsziScaleY()
    End Sub

End Class
